﻿#using Tessa.Roles

if (!string.IsNullOrEmpty((string)Signal.Comment))
{
	task.Result = string.Format(
		LocalizationManager.LocalizeAndEscapeFormat("$WfResolution_Result_ParentComment"),
		(string)Signal.Comment);
}

if (!string.IsNullOrEmpty((string)Signal.KindCaption))
{
	task.Card.DynamicEntries.TaskCommonInfo.KindCaption = (string)Signal.KindCaption;
}

var parentTask = await Context.GetTaskAsync(task.ParentRowID.Value);
if (parentTask.State != CardRowState.Deleted)
{
    var mainCard = await GetCardObjectAsync();
	parentTask = mainCard.Tasks.FirstOrDefault(x => x.RowID == parentTask.RowID);

	if(parentTask is null)
	{
		ValidationResult.AddError(this, $"Parent task (RowID = \"{parentTask.RowID:B}\") not found.");
		return;
	}

	var storeDateTime = DateTime.UtcNow;
	var newRow = parentTask.Card.Sections["WfResolutionChildren"].Rows.Add();
	newRow.RowID = task.RowID;
	newRow["PerformerID"] = task.RoleID;
	newRow["PerformerName"] = task.RoleName;
	newRow["Comment"] = (string)Signal.Comment;
	newRow["Created"] = task.Card.Created ?? storeDateTime;
	newRow["Planned"] = task.Planned ?? storeDateTime;
	newRow.State = CardRowState.Inserted;

	if (parentTask.State != CardRowState.Inserted)
	{
		parentTask.State = CardRowState.Modified;
	}
}